% launch several times the GA to select the features. Several parameters
% must be set

% SET number of independent repetitions of GA
NUM_REPETITIONS = 15;

% SET minimum number of features to consider a subset valid
MIN_FEATURES_NUMBER = 12;

% SET GA options (see gatoolbox documentation)
options = gaoptimset;
options.PopulationType = 'bitstring';
options.Display = 'final';
options.PopulationSize = 50;
options.Generations = 300;
options.TolFun = 0;
options.CrossoverFraction = 0.8;
options.EliteCount = 1;
options.MutationFcn = {@mutationuniform, 0.06};
options.StallGenLimit = 50;
options.SelectionFcn = @selectiontournament; %note: the crossover is the scattered, also called uniform or random
problem.nvars = size(DATA,2);
problem.fitnessfcn = @(x)(computeSilhouette(x));
problem.options = options;
problem.lb = 0;
problem.ub = 1;

SELECTED_FEATURES = zeros(1, NUM_FEATURES);
tmp_features = TO_KEEP;

for rep=1:NUM_REPETITIONS
    
    %init fitness
    computeSilhouette(0,DATA,LABELS,TARGET_GROUP,MIN_FEATURES_NUMBER);

    [best_features,tfxmin]=ga(problem);
    tmp_features(TO_KEEP) = best_features;
    SELECTED_FEATURES = SELECTED_FEATURES + tmp_features;

end